program raw2pch;

uses
  SysUtils;

{$R *.RES}

{

***************************
Simon's NM Sample Generator

(c) Simon Detheridge 1999

simon@widgitsw.demon.co.uk

Feel free to modify or
distribute this code, as
long as this message is
left intact.

If you modify this code,
please send me a copy of
what you do.
***************************

}

procedure DoStuff;
var
  infilename, outfilename, tempstring : string;
  WaveFile, TempFile : file;
  templatefile, outputfile : textfile;
  buf : byte;
  bytecount, filecount : integer;
  modulefound : boolean;
begin
  bytecount := 0;
  modulefound := false;

  //First, we need to get the relevant file names
  WriteLn('Simon''s Nord Modular Sample Generator');
  WriteLn('Enter input filename:');
  ReadLn(infilename);
  WriteLn('Enter a name for your new patch:');
  ReadLn(outfilename);
  if pos('.pch', outfilename) = 0 then outfilename := outfilename + '.pch';

  AssignFile(WaveFile, infilename);
  AssignFile(TempFile, 'temp');
  Reset(WaveFile, 1);
  Rewrite(TempFile, 1);

  //Then we need to divide every byte by 2, so it is
  //in a range suitable for the control sequencer
  while not EOF(WaveFile) do begin
    BlockRead(WaveFile, buf, 1);
    buf := buf div 2;
    BlockWrite(TempFile, buf, 1);
    inc(bytecount);
    if bytecount > 2048 then begin
      WriteLn('Input file length greater than 2048 bytes... Truncating.');
      exit;
    end;
  end;

  //Now close the files, and open the temp file for reading.
  CloseFile(WaveFile);
  CloseFile(TempFile);
  AssignFile(TempFile, 'temp');
  Reset(TempFile, 1);

  //Now let's parse the template patches... We're looking for
  //the string:  'Type=91' to show that we've found a control
  //sequencer, and 'P16=15' to show that we've finished filling
  //in the control parameters for the current module. (P16 =
  //number of steps...)

  //Anything beginning with 'P' between these two lines will be the
  //next control parameter in the sequence.
  for filecount := 1 to 4 do begin
    AssignFile(outputfile, IntToStr(filecount) + OutFileName);
    Rewrite(outputfile);
    AssignFile(templatefile, IntToStr(filecount) + 'Template.pch');
    Reset(templatefile);

    while not EOF(templatefile) do begin
      ReadLn(templatefile, tempstring);

      //Find out if we've entered or left an area we're supposed to be modifying.
      if CompareText('Type=91', tempstring) = 0 then modulefound := true;
      if CompareText('P16=15', tempstring) = 0 then modulefound := false;

      if modulefound and (tempstring[1] = 'P') and (not EOF(TempFile)) then begin
        //We've found a line that needs modifying... Replace the value
        BlockRead(tempfile, buf, 1);
        Delete(tempstring, pos('=', tempstring) + 1, 999);
        tempstring := tempstring + IntToStr(buf);
      end;

      WriteLn(outputfile, tempstring);
    end;

    CloseFile(outputfile);
    CloseFile(templatefile);

    if EOF(tempfile) then exit; //If there's no data left, we don't need to proceed to the next file
  end;

  CloseFile(tempfile);
  DeleteFile('temp');

  //That's it!
  WriteLn('Finished!');
end;

begin
  DoStuff;
end.
